PROGRAM_FILES_X86_VARIABLE = '%ProgramFiles(x86)%';
PROGRAM_FILES_VARIABLE = '%ProgramFiles%';
PRE_VISTA_PUBLIC_DOCUMENTS_VARIABLE = '%ALLUSERSPROFILE%\\Documents';
VISTA_AND_LATER_PUBLIC_DOCUMENTS_VARIABLE = '%PUBLIC%\\Documents';
CSS_DIR_PATH_PREFIX = '\\Motorola\\CSS\\A';
TEMP_DIR_NAME = '\\tmp';
SWDL_TMP_PATH = '\\swdl\\tmp';

function isPreVistaOperatingSystem() {
	var strComputer = ".";
	var SWBemlocator = new ActiveXObject("WbemScripting.SWbemLocator");
	var objWMIService = SWBemlocator.ConnectServer(strComputer, "/root/CIMV2");
	var colItems = objWMIService.ExecQuery("SELECT * FROM Win32_OperatingSystem");
	var e = new Enumerator(colItems);
	for (; !e.atEnd(); e.moveNext()) {
	    var systemInfo = e.item ();
		//6 is major version of windows for vista and later
		if(parseInt(systemInfo.Version) < 6) {
			return true;
		} else {
			return false;
		}
    }
	throw new Error('Operating system version can not be determined');
}

function getProgramFilesX86Path() {
	var fileSystemObject = new ActiveXObject("Scripting.FileSystemObject");
	var shell = new ActiveXObject("Wscript.Shell");
	path = shell.ExpandEnvironmentStrings(PROGRAM_FILES_X86_VARIABLE);
	if(!fileSystemObject.FolderExists(path)) {
		path = shell.ExpandEnvironmentStrings(PROGRAM_FILES_VARIABLE);
	}
	return path;
}

function getPublicDocumentsPath() {
	var shell = new ActiveXObject("Wscript.Shell");
	if(isPreVistaOperatingSystem()) {
		return shell.ExpandEnvironmentStrings(PRE_VISTA_PUBLIC_DOCUMENTS_VARIABLE);
	} else {
		return shell.ExpandEnvironmentStrings(VISTA_AND_LATER_PUBLIC_DOCUMENTS_VARIABLE);
	}
}

function getCSSPath(release) {
	return getPublicDocumentsPath() + CSS_DIR_PATH_PREFIX + release;
}

function getTmpDir(release) {
	return getCSSPath(release) + TEMP_DIR_NAME;
}

function getInstallationPath(release) {
	return getProgramFilesX86Path() + CSS_DIR_PATH_PREFIX + release;
}

function getSWDLTmpPath(release) {
	return getCSSPath(release) + SWDL_TMP_PATH;
}

function log(path, message) {
	var fileSystemObject  = new ActiveXObject("Scripting.FileSystemObject"); 
	var file = fileSystemObject.OpenTextFile(path, 8, true); 
	file.WriteLine(new Date() + '\t' + message); 
	file.Close(); 
}